<?php
/**
 * The front-page template file
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 * @package Site
 */

get_header();
while( have_posts() ) : the_post();

	$section = get_field('site_home_welcome');
	if(is_array($section)) : ?>
		<section class="c-home-welcome" id="js-welcome">

			<div class="c-home-welcome__slider swiper-container" id="js-sw-welcome">
				<div class="c-home-welcome__slider-wrap swiper-wrapper"><?php
					foreach( $section['images'] as $img ) : ?>
                        <img class="c-home-welcome__slider-item swiper-slide swiper-no-swiping"
                            src="<?php echo $img['url'] ?>" alt="<?php echo $img['title'] ?>"><?php
					endforeach ?>
				</div>
			</div>

			<div class="t-anim c-home-welcome__container">
				<article class="o-post c-home-welcome__post">
                    <h3><?php echo $section['content']; ?></h3>
                    <div class="c-home-welcome__offset t-anim"><?php
                        if(is_array($section['link'])) : ?>
                            <a class="o-btn c-home-welcome__link" href="<?php echo $section['link']['url'] ?>">
                                <?php echo $section['link']['title'] ?>
                            </a><?php
                        endif ?>
                    </div>
                    <div class="c-scroll-icon c-home-welcome__scroll t-anim"><span>SCROLL</span></div>
				</article>
			</div>

		</section><?php
	endif;

	$section = get_field('site_home_highlight');
	if(is_array($section)) : ?>
		<section class="c-home-highlight">
			<div class="o-container" id="js-highlight">

				<article class="o-post c-home-highlight__post">
					<div class="c-home-highlight__pics js-item-0 t-anim">
                        <img class="c-home-highlight__pic c-home-highlight__pic--0" src="<?php echo $section['base_image'] ?>" alt="0">
                    </div>
                    <div class="c-home-highlight__text">
                        <h2 class="c-home-highlight__title c-home-highlight__title--0 js-item-1 t-anim">Thinking</h2>
                        <h1 class="c-home-highlight__title c-home-highlight__title--1 js-item-2 t-anim">&amp;</h1>
                        <h2 class="c-home-highlight__title c-home-highlight__title--2 js-item-3 t-anim">Creating</h2>
                    </div>
					<h5 class="js-item-4 t-anim"><?php echo $section['content']; ?></h5>
				</article>

			</div>
		</section><?php
	endif;

	$section = get_field('site_home_solutions');
	if(is_array($section)) : ?>
		<section class="c-home-solution" id="js-sols">
			<div class="o-container">

				<article class="o-post c-home-solution t-anim" id="js-sol-text">
					<h2 class="o-text__home-title o-text__home-title--body">
                        <?php echo $section['title'] ?>
                    </h2>
				</article><?php

				if( is_array($section['points']) ) : ?>
					<div class="c-home-solution__point t-anim" id="js-sol-points">
                        <div class="c-home-solution__point-wrap swiper-container" id="js-sw-sols">
                            <div class="swiper-wrapper"><?php
                                foreach( $section['points'] as $k => $p ) : ?>
                                    <img class="c-home-solution__point-item swiper-slide swiper-no-swiping" src="<?php echo $p['image'] ?>"
                                        alt="<?php echo $p['title'] ?>"><?php
                                endforeach ?>
                            </div>
                        </div><?php
                        foreach( $section['points'] as $k => $p ) : ?>
                            <div class="c-home-solution__p-icon c-home-solution__p-icon--<?php echo $k ?> js-sol-page"
                                data-slide="<?php echo $k ?>"></div><?php
                        endforeach ?>
                        <button class="o-btn-arr o-btn-arr--alt o-btn-arr--next" id="js-sol-next"><span></span></button>
                        <button class="o-btn-arr o-btn-arr--alt o-btn-arr--opp" id="js-sol-prev"><span></span></button>
                        <img class="c-home-solution__mask" src="<?php echo get_template_directory_uri() ?>/assets/svg/360_wrap.svg">
					</div>
                    <h5 class="c-home-solution__title t-anim" id="js-sol-title"></h5><?php
				endif ?>

			</div>
		</section><?php
	endif;

	$section = get_field('site_home_core_section');
	if(is_array($section)) : ?>
		<section class="c-home-core">

            <div class="o-container" id="js-core">
				<article class="o-post c-home-core t-anim js-title">
					<h2 class="o-text__home-title o-text__home-title--primary">
                        <?php echo $section['title'] ?>
                    </h2>
				</article><?php

				if( is_array($section['points']) ) : ?>
					<div class="c-home-core__point">
						<div class="c-home-core__wrap">
                            <div class="c-home-core__col c-home-core__col--title t-anim js-item">
                                <article>
                                    <div class="swiper-container" id="js-sw-core-text">
                                        <div class="swiper-wrapper"><?php
                                            foreach( $section['points'] as $p ) : ?>
                                                <div class="c-home-core__text swiper-slide">
                                                    <h5><?php echo $p['title'] ?></h5>
                                                </div><?php
                                            endforeach ?>
                                        </div>
                                    </div>
                                    <div class="c-home-core__ctrl">
                                        <button class="o-btn-arr o-btn-arr--opp" id="js-core-prev"><span></span></button>
                                        <button class="o-btn-arr o-btn-arr--next" id="js-core-next"><span></span></button>
                                        <div class="c-home-core__pager" id="js-core-pager"></div>
                                    </div>
                                    <img src="<?php echo get_template_directory_uri() ?>/assets/svg/dash.svg"
                                        alt="-" class="c-home-core__dash">
                                </article>
                            </div>
                            <div class="c-home-core__col c-home-core__col--points t-anim js-item">
                                <div class="swiper-container" id="js-sw-core-pics">
                                    <div class="swiper-wrapper"><?php
                                        foreach( $section['points'] as $p ) : ?>
                                            <div class="c-home-core__item swiper-slide"
                                                style="background-image:url('<?php echo $p['bg'] ?>');">&nbsp;</div><?php
                                        endforeach ?>
                                    </div>
                                </div>
                            </div>
						</div>
					</div><?php
				endif ?>
			</div>

            <div class="c-home-core__base" id="js-core-b">
                <div class="o-container">
                    <div class="c-home-core__b">
                        <div class="c-home-core__b-wrap"><?php
                            foreach( $section['blocks'] as $k => $b ) : ?>
                                <div class="c-home-core__b-item <?php echo $k < 2 ? 'js-item-0 t-anim' : '' ?> <?php echo $k > 3 ? 'js-item-1 t-anim' : '' ?>">
                                    <img src="<?php echo $b['url'] ?>" alt="b-<?php echo $k ?>">
                                </div><?php
                            endforeach ?>
                        </div>
                    </div>
                </div>
            </div>

		</section><?php
	endif;

	$section = get_field('site_home_business_section');
	if(is_array($section)) : ?>
		<section class="c-home-business" id="js-busi">
			<div class="o-container">

				<article class="o-post c-home-business__post t-anim js-title">
					<h2 class="o-text__home-title"><?php echo $section['title'] ?></h2>
				</article><?php

				if( is_array($section['points']) ) : ?>
					<div class="o-table c-home-business__point">
						<div class="o-table__wrap c-home-business__point-wrap"><?php
							foreach( $section['points'] as $k => $p ) : ?>
								<div class="o-table__col c-home-business__point-item t-anim js-item">
                                    <a href="#" class="js-business-trig" data-overlay="<?php echo $k ?>">
                                        <img class="c-home-business__image" src="<?php echo $p['bg_image'] ?>" alt="">
                                        <h5><?php echo $p['title'] ?></h5>
                                        <button class="o-btn-arr"><span></span></button>
                                    </a>
								</div><?php
							endforeach ?>
						</div>
					</div><?php
				endif ?>

			</div>
		</section>
        <div class="c-home-business__overlay    " id="js-overlay">
            <div class="swiper-container c-home-business__o-container" id="js-sw-overlay">
                <div class="swiper-wrapper"><?php
                    foreach( $section['points'] as $k => $p ) : ?>

                        <div class="swiper-slide c-home-business__o-item js-overlay-item">
                            <div class="o-container">
                                <div class="o-table">
                                    <div class="o-table__wrap">
                                        <div class="o-table__col">
                                            <img class="c-home-business__image c-home-business__o-img t-anim js-overlay-img" src="<?php echo $p['image'] ?>" alt="Image">
                                        </div>
                                        <div class="o-table__col">
                                            <article class="o-post c-home-business__o-post t-anim js-overlay-text">
                                                <h2><?php echo $p['title'] ?></h2>
                                                <?php echo apply_filters('the_content', $p['content']) ?>
                                            </article>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div><?php

                    endforeach; ?>
                </div>
            </div>
            <button class="o-btn-x c-home-business__o-close js-close-overlay"><span></span></button>
            <button class="o-btn-arr"  id="js-sw-overlay-next"><span></span></button>
            <button class="o-btn-arr o-btn-arr--opp"  id="js-sw-overlay-prev"><span></span></button>
        </div><?php
	endif;

	$section = get_field('site_home_range_section');
	if(is_array($section)) : ?>
		<section class="c-home-range" id="js-range">
            <div class="c-home-range__container"><?php
                if( is_array($section['points']) ) : ?>
                    <div class="c-home-range__wrap" id="js-wrap">

                        <div class="c-home-range__points">
                            <div class="c-home-range__post t-anim js-title">
                                <article class="o-post">
                                    <h2><?php echo $section['title'] ?></h2>
                                    <p><?php echo $section['content'] ?></p>
                                </article>
                            </div>
                            <div class="c-home-range__t">
                                <div class="c-home-range__t-wrap"><?php
                                    foreach( $section['points'] as $k => $p ) : ?>
                                        <div class="c-home-range__t-col c-home-range__t-col--<?php echo $k ?> c-home-range__point"
                                            style="background-image:url('<?php echo $p['bg_image'] ?>');">
                                            <article class="o-post c-home-range__cta js-trig t-anim js-item"
                                                data-detail="js-detail-<?php echo $k ?>">
                                                <h5><?php echo $p['title'] ?></h5>
                                                <button class="o-btn-arr o-btn-arr--sec"><span></span></button>
                                            </article>
                                        </div><?php
                                    endforeach ?>
                                </div>
                            </div>
                        </div>

                        <div class="c-home-range__detail"><?php
                            foreach( $section['points'] as $k => $p ) : ?>
                                <div class="c-home-range__t c-home-range__t--detail js-detail" id="js-detail-<?php echo $k ?>">
                                    <div class="c-home-range__t-wrap">
                                        <div class="c-home-range__t-col c-home-range__t-col--<?php echo $k ?> c-home-range__t-col--d-pic"
                                            style="background-image:url('<?php echo $p['image'] ?>');">&nbsp;</div>
                                        <div class="c-home-range__t-col">
                                            <article class="o-post c-home-range__detail-post t-anim js-range-detail">
                                                <button class="o-btn-arr o-btn-arr--opp o-btn-arr--alt js-close"><span></span></button>
                                                <h2><?php echo $p['title'] ?></h2>
                                                <?php echo apply_filters('the_content', $p['content']) ?>
                                            </article>
                                        </div>
                                    </div>
                                </div><?php
                            endforeach ?>
                        </div>

                    </div><?php
                endif ?>
            </div>
	   </section><?php
	endif; ?>

    <section class="c-home-presence" id="js-pre">
        <div class="o-container">
            <article class="o-post c-home-presence__post">
                <h2 class="o-text__home-title o-text__home-title--primary t-anim js-title">Market Presence</h2>
                <div class="c-home-presence__map">
                    <img src="<?php echo get_template_directory_uri() ?>/assets/svg/map.svg">
                    <div class="c-home-presence__loc c-home-presence__loc--0 t-anim js-item">European Union</div>
                    <div class="c-home-presence__loc c-home-presence__loc--1 t-anim js-item">Middle East</div>
                    <div class="c-home-presence__loc c-home-presence__loc--2 t-anim js-item">Thailand</div>
                    <div class="c-home-presence__loc c-home-presence__loc--3 t-anim js-item">Korea</div>
                    <div class="c-home-presence__loc c-home-presence__loc--4 t-anim js-item">Japan</div>
                    <div class="c-home-presence__loc c-home-presence__loc--5 t-anim js-item">Australia</div>
                </div>
            </article>
        </div>
    </section><?php

	$section = get_field('site_home_thai_section');
	if(is_array($section)) : ?>
        <section class="c-home-thai" id="js-thai">
    		<div class="c-home-thai__wrap" id="js-thai-wrap" style="background-image:url('<?php echo $section['image'] ?>');">
    			<div class="o-container">
    				<article class="o-post c-home-thai__post">
    					<h1 class="t-anim js-item"><?php echo $section['title'] ?></h1>
    					<h3 class="t-anim js-item"><?php echo $section['sub-title'] ?></h3>
    					<h5 class="t-anim js-item"><?php echo $section['content'] ?></h5>
    				</article>
    			</div>
            </div>
		</section><?php
	endif;

endwhile;
get_footer();
