<?php
/**
 * Site functions and definitions
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 * @package Site
 */

if ( ! function_exists( 'site_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function site_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Site, use a find and replace
		 * to change 'site' to the name of your theme in all the template files.
		 */
        load_theme_textdomain( 'site', get_template_directory() . '/languages' );

		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
        ) );

		/*
         * This theme uses wp_nav_menu() in one location.
         */
		register_nav_menus( array(
            'site_header_menu' => esc_html__( 'Primary', 'site' ),
            'site_footer_menu' => esc_html__( 'Footer', 'site' ),
		) );

		/*
		 * Create some custom post types.
		 */
        require 'inc/vendor/cpt-class.php';
        if( class_exists( 'Post_Type' ))
        {
            // INIT CUSTOM POST TYPES
        }
	}
endif;
add_action( 'after_setup_theme', 'site_setup' );

// -------------------------------------------------------------------------------------------
// -- Set the content width in pixels, based on the theme's design and stylesheet. --
// -------------------------------------------------------------------------------------------

function site_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'site_content_width', 1280 );
}
add_action( 'after_setup_theme', 'site_content_width', 0 );

// -------------------------------------------------------------------------------------------
// -- SVG Support --
// -------------------------------------------------------------------------------------------

function site_cc_mime_types($mimes) {
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}

function site_fix_svg() {
    echo '<style type="text/css">
          .attachment-266x266, .thumbnail img {
               width: 100% !important;
               height: auto !important;
          }
          </style>';
 }

add_action('admin_head', 'site_fix_svg');
add_filter('upload_mimes', 'site_cc_mime_types');

// -------------------------------------------------------------------------------------------
// -- Remove Unwanted Enqueues --
// -------------------------------------------------------------------------------------------

remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
remove_action( 'wp_print_styles', 'print_emoji_styles' );
add_filter( 'emoji_svg_url', '__return_false' );

// -------------------------------------------------------------------------------------------
// -- DISABLE UPDATES --
// -------------------------------------------------------------------------------------------

function remove_core_updates(){
    global $wp_version;return(object) array('last_checked'=> time(),'version_checked'=> $wp_version,);
}
add_filter('pre_site_transient_update_core','remove_core_updates');
add_filter('pre_site_transient_update_plugins','remove_core_updates');
add_filter('pre_site_transient_update_themes','remove_core_updates');

// -------------------------------------------------------------------------------------------
// -- REMOVE DEFAULT JQUERY --
// -------------------------------------------------------------------------------------------

function remove_jquery_enqueue() {
   wp_deregister_script('jquery');
}
//if (!is_admin()) add_action("wp_enqueue_scripts", "remove_jquery_enqueue", 11);

// -------------------------------------------------------------------------------------------
// -- Enqueue styles. --
// -------------------------------------------------------------------------------------------

function site_styles()
{
    wp_enqueue_style( 'google-font-style', 'https://fonts.googleapis.com/css?family=Montserrat:200,300,400,700' );
	wp_enqueue_style( 'site-style', get_template_directory_uri() . '/assets/css/style.css' );
}
add_action( 'wp_enqueue_scripts', 'site_styles' );

// -------------------------------------------------------------------------------------------
// -- Enqueue scripts. --
// -------------------------------------------------------------------------------------------

function site_scripts()
{
    wp_register_script(
        'swipper-js',
        get_template_directory_uri() . '/assets/js/vendor/swiper.min.js',
        array('jquery'),
        '2.1.6',
        true
    );

    wp_register_script(
        'anime-js',
        get_template_directory_uri() . '/assets/js/vendor/anime.min.js',
        array('jquery'),
        '2.1.6',
        true
    );

    wp_enqueue_script('site-js', get_template_directory_uri() . '/assets/js/site.js', array('jquery'), '1.0', true );
    if(is_front_page())
    {
        wp_enqueue_script(
            'home-js',
            get_template_directory_uri() . '/assets/js/home.js',
            array('anime-js', 'swipper-js'),
            '1.0',
            true
        );
    }
}
add_action( 'wp_enqueue_scripts', 'site_scripts' );
// -------------------------------------------------------------------------------------------
// -- OTHER REQUIREMENTS. --
// -------------------------------------------------------------------------------------------

require get_template_directory() . '/inc/init-customizer.php';
require get_template_directory() . '/inc/init-acf.php';
require get_template_directory() . '/inc/init-shortcodes.php';
require get_template_directory() . '/inc/vendor/columns.php';
