<?php
/**
 * The page template file
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 * @package Site
 */

get_header();
while( have_posts() ) :the_post();
    $f_img = get_the_post_thumbnail_url(); ?>

    <section class="c-page-header" style="background-image:url('<?php echo $f_img; ?>');">
        <article class="c-page-header__post">
            <div class="o-container">
                <h1><?php the_title() ?></h1>
                <?php edit_post_link() ?>
            </div>
        </article>
    </section>

	<section class="c-page-content c-page-content--<?php echo $post->post_name ?> t-anim" data-entrance="from-bottom">
		<div class="o-container">
            <div class="o-table">
                <div class="o-table__wrap">

                    <div class="o-table__col">
                        <article class="o-post">
                            <h4>Address</h4>
                            <address>
                                <strong><?php bloginfo('name') ?></strong><br>
                                <?php echo nl2br( get_option( 'options_contact_detail_address', '' )) ?>
                            </address>
                        </article>
                    </div>

                    <div class="o-table__col">
                        <article class="o-post">
                            <h4>Phone</h4>
                            <p>
                                <a href="tel:<?php echo get_option( 'options_contact_detail_phone', '' ) ?>">
                                    <?php echo get_option( 'options_contact_detail_phone', '' ) ?>
                                </a>
                            </p>
                        </article>
                    </div>

                    <div class="o-table__col">
                        <article class="o-post">
                            <h4>Email</h4>
                            <p>
                                <a href="mailto:<?php echo get_option( 'options_contact_detail_email', '' ) ?>">
                                    <?php echo get_option( 'options_contact_detail_email', '' ) ?>
                                </a>
                            </p>
                        </article>
                    </div>

                </div>
            </div>
		</div>
    </section>

    <section>
        <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d13732.766928174278!2d100.58401028006918!3d13.721403598343338!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x30e29fba8e8f5b07%3A0x1b5802810dc2491f!2sChaiyapruk+Place!5e0!3m2!1sen!2sin!4v1545377432186" width="100%" height="400" frameborder="0" style="border:0" allowfullscreen></iframe>
    </section><?php

endwhile;
get_footer();
